<?php

namespace App\Http\Controllers;

use App\Models\AreaMaster;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class AreaMasterController extends Controller
{
    public function index()
    {
        $areas = AreaMaster::with(['ward' => function($query) {
            $query->select('Wrd_Id', 'Wrd_Code', 'Wrd_Name', 'Zon_Id', 'is_active');
        }])->get();

        return response()->json([
            'success' => true,
            'data' => $areas
        ]);
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'Are_Code' => 'nullable|string|max:5|unique:area_master,Are_Code',
            'Are_Name' => 'required|string|max:255',
            'Wrd_Id' => 'nullable|integer|exists:ward_master,Wrd_Id',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'errors' => $validator->errors()
            ], 422);
        }

        $area = AreaMaster::create($request->all());

        $area->load(['ward' => function($query) {
            $query->select('Wrd_Id', 'Wrd_Code', 'Wrd_Name', 'Zon_Id', 'is_active');
        }]);

        return response()->json([
            'success' => true,
            'data' => $area,
            'message' => 'Are created successfully'
        ], 201);
    }

    public function show($id)
    {
        $area = AreaMaster::with(['ward' => function($query) {
            $query->select('Wrd_Id', 'Wrd_Code', 'Wrd_Name', 'Zon_Id', 'is_active');
        }])->find($id);

        if (!$area) {
            return response()->json([
                'success' => false,
                'message' => 'Are not found'
            ], 404);
        }

        return response()->json([
            'success' => true,
            'data' => $area
        ]);
    }

    public function update(Request $request, $id)
    {
        $area = AreaMaster::find($id);

        if (!$area) {
            return response()->json([
                'success' => false,
                'message' => 'Are not found'
            ], 404);
        }

        $validator = Validator::make($request->all(), [
            'Are_Code' => 'string|max:5|unique:area_master,Are_Code,' . $id . ',Are_Id',
            'Are_Name' => 'string|max:255',
            'Wrd_Id' => 'nullable|integer|exists:ward_master,Wrd_Id',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'errors' => $validator->errors()
            ], 422);
        }

        $area->update($request->all());

        $area->load(['ward' => function($query) {
            $query->select('Wrd_Id', 'Wrd_Code', 'Wrd_Name', 'Zon_Id', 'is_active');
        }]);

        return response()->json([
            'success' => true,
            'data' => $area,
            'message' => 'Are updated successfully'
        ]);
    }

    public function destroy($id)
    {
        $area = AreaMaster::find($id);

        if (!$area) {
            return response()->json([
                'success' => false,
                'message' => 'Are not found'
            ], 404);
        }

        $area->delete();

        return response()->json([
            'success' => true,
            'message' => 'Are deleted successfully'
        ]);
    }

    public function search(Request $request)
    {
        $query = AreaMaster::with(['ward' => function($query) {
            $query->select('Wrd_Id', 'Wrd_Code', 'Wrd_Name', 'Zon_Id', 'is_active');
        }]);

        if ($request->has('search')) {
            $search = $request->search;
            $query->where('Are_Name', 'like', '%' . $search . '%')
                  ->orWhere('Are_Code', 'like', '%' . $search . '%');
        }

        $areas = $query->get();

        return response()->json([
            'success' => true,
            'data' => $areas
        ]);
    }
}
