<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\AwardMaster;

class AwardMasterController extends Controller
{
    /**
     * List with Pagination + Search
     */
    public function index(Request $request)
    {
        $query = AwardMaster::query();

        // Search
        if ($request->search) {
            $search = $request->search;

            $query->where(function ($q) use ($search) {
                $q->where('Awrd_Name', 'like', "%$search%")
                  ->orWhere('Awrd_Code', 'like', "%$search%")
                  ->orWhere('Awrding_Auth', 'like', "%$search%")
                  ->orWhere('Awrd_Year', 'like', "%$search%");
            });
        }

        $data = $query->orderBy('Awrd_Id', 'desc')
                      ->paginate($request->per_page ?? 15);

        return response()->json([
            'status' => true,
            'message' => 'Award list fetched successfully',
            'data' => $data
        ]);
    }

    /**
     * All Data without Pagination
     */
    public function all()
    {
        $data = AwardMaster::orderBy('Awrd_Name')->get();

        return response()->json([
            'status' => true,
            'data' => $data
        ]);
    }

    /**
     * Store
     */
    public function store(Request $request)
    {
        $request->validate([
            'Awrd_Name' => 'required|string|max:50',
        ]);

        $award = AwardMaster::create($request->all());

        return response()->json([
            'status' => true,
            'message' => 'Award created successfully',
            'data' => $award
        ]);
    }

    /**
     * Show Single
     */
    public function show($id)
    {
        $award = AwardMaster::find($id);

        if (!$award) {
            return response()->json([
                'status' => false,
                'message' => 'Award not found'
            ], 404);
        }

        return response()->json([
            'status' => true,
            'data' => $award
        ]);
    }

    /**
     * Update
     */
    public function update(Request $request, $id)
    {
        $award = AwardMaster::find($id);

        if (!$award) {
            return response()->json([
                'status' => false,
                'message' => 'Award not found'
            ], 404);
        }

        $award->update($request->all());

        return response()->json([
            'status' => true,
            'message' => 'Award updated successfully',
            'data' => $award
        ]);
    }

    /**
     * Delete (Soft Delete)
     */
    public function destroy($id)
    {
        $award = AwardMaster::find($id);

        if (!$award) {
            return response()->json([
                'status' => false,
                'message' => 'Award not found'
            ], 404);
        }

        $award->delete();

        return response()->json([
            'status' => true,
            'message' => 'Award deleted successfully'
        ]);
    }
}
