<?php

namespace App\Http\Controllers;

use App\Models\GrantAuthoMaster;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class GrantAuthoMasterController extends Controller
{
    /* ================= LIST ================= */

    public function index(Request $request)
    {
        try {

            $query = GrantAuthoMaster::query();

            if ($request->has('search')) {
                $query->where(function ($q) use ($request) {
                    $q->where('GA_Code', 'like', "%{$request->search}%")
                      ->orWhere('GA_Name', 'like', "%{$request->search}%");
                });
            }

            $perPage = $request->get('per_page', 15);
            $data = $query->paginate($perPage);

            return response()->json([
                'success' => true,
                'data' => $data
            ]);

        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => $e->getMessage()
            ], 500);
        }
    }
public function all()
{
    try {
        return response()->json([
            'success' => true,
            'data' => GrantAuthoMaster::latest()->get()
        ]);
    } catch (\Exception $e) {
        return response()->json([
            'success' => false,
            'message' => $e->getMessage()
        ], 500);
    }
}

    /* ================= STORE ================= */

    public function store(Request $request)
    {
        try {

            $validator = Validator::make(
                $request->all(),
                GrantAuthoMaster::createRules()
            );

            if ($validator->fails()) {
                return response()->json([
                    'success' => false,
                    'errors' => $validator->errors()
                ], 422);
            }

            $data = GrantAuthoMaster::create($request->all());

            return response()->json([
                'success' => true,
                'message' => 'Grant Authority created successfully',
                'data' => $data
            ], 201);

        } catch (\Exception $e) {

            return response()->json([
                'success' => false,
                'message' => $e->getMessage()
            ], 500);
        }
    }

    /* ================= SHOW ================= */

    public function show($id)
    {
        $data = GrantAuthoMaster::find($id);

        if (!$data) {
            return response()->json([
                'success' => false,
                'message' => 'Record not found'
            ], 404);
        }

        return response()->json([
            'success' => true,
            'data' => $data
        ]);
    }

    /* ================= UPDATE ================= */

    public function update(Request $request, $id)
    {
        $data = GrantAuthoMaster::find($id);

        if (!$data) {
            return response()->json([
                'success' => false,
                'message' => 'Record not found'
            ], 404);
        }

        $validator = Validator::make(
            $request->all(),
            GrantAuthoMaster::updateRules($id)
        );

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'errors' => $validator->errors()
            ], 422);
        }

        $data->update($request->all());

        return response()->json([
            'success' => true,
            'message' => 'Grant Authority updated successfully',
            'data' => $data
        ]);
    }

    /* ================= DELETE (SOFT) ================= */

    public function destroy($id)
    {
        $data = GrantAuthoMaster::find($id);

        if (!$data) {
            return response()->json([
                'success' => false,
                'message' => 'Record not found'
            ], 404);
        }

        $data->delete();

        return response()->json([
            'success' => true,
            'message' => 'Grant Authority deleted successfully'
        ]);
    }

    /* ================= RESTORE ================= */

    public function restore($id)
    {
        $data = GrantAuthoMaster::withTrashed()->find($id);

        if (!$data) {
            return response()->json([
                'success' => false,
                'message' => 'Record not found'
            ], 404);
        }

        $data->restore();

        return response()->json([
            'success' => true,
            'message' => 'Grant Authority restored successfully',
            'data' => $data
        ]);
    }
}
