<?php

namespace App\Http\Controllers;

use App\Models\Parameter;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class ParameterController extends Controller
{
    // LIST
    public function index()
    {
        $data = Parameter::all();

        return response()->json([
            'status' => true,
            'data' => $data
        ]);
    }

    // STORE
    public function store(Request $request)
    {
       $validator = Validator::make($request->all(), [
    'Date_format'   => 'nullable|date',
    'Time_format'   => 'nullable|date_format:H:i:s',
    'Currency'      => 'nullable|string|max:25',
    'Amount' => ['required','numeric','regex:/^\d{1,13}(\.\d{1,2})?$/'],
    'Text'          => 'nullable|string|max:255',
    'Db_Row_limit'  => 'nullable|integer',
    'Is_Active'     => 'required|in:0,1',
]);


        if ($validator->fails()) {
            return response()->json([
                'status' => false,
                'errors' => $validator->errors()
            ], 422);
        }

        $data = Parameter::create($request->all());

        return response()->json([
            'status' => true,
            'message' => 'Parameter Created Successfully',
            'data' => $data
        ]);
    }

    // SHOW
    public function show($id)
    {
        $data = Parameter::find($id);

        if (!$data) {
            return response()->json([
                'status' => false,
                'message' => 'Parameter Not Found'
            ]);
        }

        return response()->json([
            'status' => true,
            'data' => $data
        ]);
    }

    // UPDATE
    public function update(Request $request, $id)
    {
        $data = Parameter::find($id);

        if (!$data) {
            return response()->json([
                'status' => false,
                'message' => 'Parameter Not Found'
            ]);
        }

       $validator = Validator::make($request->all(), [
    'Date_format'   => 'nullable|date',
    'Time_format'   => 'nullable|date_format:H:i:s',
    'Currency'      => 'nullable|string|max:25',
    'Amount'        => 'nullable|numeric',
    'Text'          => 'nullable|string|max:255',
    'Db_Row_limit'  => 'nullable|integer|min:1|max:1000',
    'Is_Active'     => 'nullable|boolean',
]);


        if ($validator->fails()) {
            return response()->json([
                'status' => false,
                'errors' => $validator->errors()
            ], 422);
        }

        $data->update($request->all());

        return response()->json([
            'status' => true,
            'message' => 'Parameter Updated Successfully',
            'data' => $data
        ]);
    }

    // DELETE (Soft Delete)
    public function destroy($id)
    {
        $data = Parameter::find($id);

        if (!$data) {
            return response()->json([
                'status' => false,
                'message' => 'Parameter Not Found'
            ]);
        }

        $data->delete();

        return response()->json([
            'status' => true,
            'message' => 'Parameter Deleted Successfully'
        ]);
    }
}
