<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\PayAlwdedMaster;

class PayAlwdedMasterController extends Controller
{
    /**
     * List with Search & Pagination
     */
    public function index(Request $request)
    {
        $query = PayAlwdedMaster::query();

        // Search
        if ($request->search) {
            $search = $request->search;

            $query->where(function ($q) use ($search) {
                $q->where('PAD_ShortName', 'like', "%$search%")
                  ->orWhere('PAD_Name', 'like', "%$search%")
                  ->orWhere('Percentage', 'like', "%$search%");
            });
        }

        $data = $query->orderBy('PAD_Id', 'desc')
                      ->paginate(10);

        return response()->json([
            'status' => true,
            'message' => 'Pay Allowance/Deduction List',
            'data' => $data
        ]);
    }

    /**
     * Store
     */
    public function store(Request $request)
    {
        $request->validate([
            'PAD_Code' => 'required',
            'PAD_ShortName' => 'required',
            'PAD_Name' => 'required',
            'Percentage' => 'required|numeric'
        ]);

        $data = PayAlwdedMaster::create($request->all());

        return response()->json([
            'status' => true,
            'message' => 'Created Successfully',
            'data' => $data
        ]);
    }

    /**
     * Show Single
     */
    public function show($id)
    {
        $data = PayAlwdedMaster::find($id);

        if (!$data) {
            return response()->json([
                'status' => false,
                'message' => 'Record Not Found'
            ], 404);
        }

        return response()->json([
            'status' => true,
            'data' => $data
        ]);
    }

    /**
     * Update
     */
    public function update(Request $request, $id)
    {
        $data = PayAlwdedMaster::find($id);

        if (!$data) {
            return response()->json([
                'status' => false,
                'message' => 'Record Not Found'
            ], 404);
        }

        $data->update($request->all());

        return response()->json([
            'status' => true,
            'message' => 'Updated Successfully',
            'data' => $data
        ]);
    }

    /**
     * Delete (Soft Delete)
     */
    public function destroy($id)
    {
        $data = PayAlwdedMaster::find($id);

        if (!$data) {
            return response()->json([
                'status' => false,
                'message' => 'Record Not Found'
            ], 404);
        }

        $data->delete();

        return response()->json([
            'status' => true,
            'message' => 'Deleted Successfully'
        ]);
    }

    /**
     * All Data without Pagination
     */
    public function all()
    {
        $data = PayAlwdedMaster::orderBy('PAD_Id', 'desc')->get();

        return response()->json([
            'status' => true,
            'data' => $data
        ]);
    }
}
