<?php

namespace App\Http\Controllers;

use App\Models\PayCommissionMaster;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class PayCommissionMasterController extends Controller
{
    public function index(Request $request)
    {
        try {
            $query = PayCommissionMaster::with('structureType');

            $perPage = $request->get('per_page', 25);

            if ($perPage === 'all') {
                $data = $query->get();
            } else {
                $data = $query->paginate((int) $perPage);
            }

            return response()->json([
                'success' => true,
                'data' => $data
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => $e->getMessage()
            ], 500);
        }
    }
    public function all()
    {
        try {
            $data = PayCommissionMaster::with('structureType')->get();

            return response()->json([
                'success' => true,
                'data' => $data
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => $e->getMessage()
            ], 500);
        }
    }


    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'PC_Name'   => 'required|string|max:50',
            'PST_Id'    => 'nullable|exists:pay_strtype_master,PST_Id',
            'Eff_From'  => 'required|date',
            'Eff_To'    => 'nullable|date',
            'PST_Desc'  => 'nullable|string',
            'Is_Active' => 'boolean'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'errors' => $validator->errors()
            ], 422);
        }

        $commission = PayCommissionMaster::create($validator->validated());

        return response()->json([
            'success' => true,
            'message' => 'Pay Commission created successfully',
            'data' => $commission
        ], 201);
    }

    public function show(string $id)
    {
        $commission = PayCommissionMaster::with('structureType')->find($id);

        if (!$commission) {
            return response()->json([
                'success' => false,
                'message' => 'Pay Commission not found'
            ], 404);
        }

        return response()->json([
            'success' => true,
            'data' => $commission
        ]);
    }

    public function update(Request $request, string $id)
    {
        $commission = PayCommissionMaster::find($id);

        if (!$commission) {
            return response()->json([
                'success' => false,
                'message' => 'Pay Commission not found'
            ], 404);
        }

        $validator = Validator::make($request->all(), [
            'PC_Name'   => 'string|max:50',
            'PST_Id'    => 'nullable|exists:pay_strtype_master,PST_Id',
            'Eff_From'  => 'date',
            'Eff_To'    => 'nullable|date',
            'PST_Desc'  => 'nullable|string',
            'Is_Active' => 'boolean'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'errors' => $validator->errors()
            ], 422);
        }

        $commission->update($validator->validated());

        return response()->json([
            'success' => true,
            'message' => 'Pay Commission updated successfully',
            'data' => $commission
        ]);
    }

    public function destroy(string $id)
    {
        $commission = PayCommissionMaster::find($id);

        if (!$commission) {
            return response()->json([
                'success' => false,
                'message' => 'Pay Commission not found'
            ], 404);
        }

        $commission->delete();

        return response()->json([
            'success' => true,
            'message' => 'Pay Commission deleted successfully'
        ]);
    }

    public function getCommissionDetails(string $id)
    {
        $commission = PayCommissionMaster::with([
            'payScales',
            'payBands',
            'gradePays',
            'payMatrixLevels'
        ])->find($id);

        if (!$commission) {
            return response()->json([
                'success' => false,
                'message' => 'Commission not found'
            ], 404);
        }

        return response()->json([
            'success' => true,
            'data' => $commission
        ]);
    }
}
