<?php

namespace App\Http\Controllers;

use App\Models\PayStrtypeMaster;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class PayStrtypeMasterController extends Controller
{
    // ✅ Get All
    public function index(Request $request)
    {
        try {
            $query = PayStrtypeMaster::query();

            $perPage = $request->get('per_page', 25);

            if ($perPage === 'all') {
                $data = $query->get();
            } else {
                $data = $query->paginate((int) $perPage);
            }

            return response()->json([
                'success' => true,
                'data' => $data
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => $e->getMessage()
            ]);
        }
    }

    // LIST ALL (NO PAGINATION)
    public function all()
    {
        try {
            $data = PayStrtypeMaster::all();

            return response()->json([
                'success' => true,
                'data' => $data
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => $e->getMessage()
            ]);
        }
    }

    // ✅ Store
    public function store(Request $request)
    {
        try {

            $validator = Validator::make($request->all(), [
                'PST_Type' => 'required|max:30'
            ]);

            if ($validator->fails()) {
                return response()->json($validator->errors(), 422);
            }

            $data = PayStrtypeMaster::create($request->all());

            return response()->json([
                'success' => true,
                'message' => 'Created',
                'data' => $data
            ]);
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'message' => $e->getMessage()]);
        }
    }

    // ✅ Show Single
    public function show($id)
    {
        try {
            $data = PayStrtypeMaster::find($id);

            return response()->json([
                'success' => true,
                'data' => $data
            ]);
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'message' => $e->getMessage()]);
        }
    }

    // ✅ Update
    public function update(Request $request, $id)
    {
        try {
            $data = PayStrtypeMaster::find($id);

            $data->update($request->all());

            return response()->json([
                'success' => true,
                'message' => 'Updated',
                'data' => $data
            ]);
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'message' => $e->getMessage()]);
        }
    }

    // ✅ Delete
    public function destroy($id)
    {
        try {
            $data = PayStrtypeMaster::find($id);
            $data->delete();

            return response()->json([
                'success' => true,
                'message' => 'Deleted'
            ]);
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'message' => $e->getMessage()]);
        }
    }
}
