<?php

namespace App\Http\Controllers;

use App\Models\ShiftMaster;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Database\Eloquent\ModelNotFoundException;

class ShiftMasterController extends Controller
{
    public function index(Request $request)
    {
        try {
            $perPage = $request->get('per_page', 15);
            $shifts = ShiftMaster::paginate($perPage);

            return response()->json([
                'success' => true,
                'data' => $shifts,
                'message' => 'Shifts retrieved successfully'
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Error retrieving shifts',
                'error' => $e->getMessage()
            ], 500);
        }
    }

    public function all()
    {
        try {
            $shifts = ShiftMaster::all();

            return response()->json([
                'success' => true,
                'data' => $shifts,
                'message' => 'All shifts retrieved successfully'
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Error retrieving shifts',
                'error' => $e->getMessage()
            ], 500);
        }
    }

    public function store(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'Sf_Code' => 'nullable|string|max:255',
                'Sf_Name' => 'nullable|string|max:255',
                'Sf_Type' => 'nullable|string|max:255',
                'Sf_Stime' => 'nullable|string|max:255',
                'Sf_Etime' => 'nullable|string|max:255',
                'Sf_Hours' => 'nullable|string|max:255',
                'Sf_MidNight' => 'nullable|string|max:255',
                'Brk_Stime' => 'nullable|string|max:255',
                'Brk_Etime' => 'nullable|string|max:255',
                'Grc_In_Mnt' => 'nullable|string|max:255',
                'Grc_Out_Mnt' => 'nullable|string|max:255',
                'LtMrk_After' => 'nullable|string|max:255',
                'ErlMrk_Before' => 'nullable|string|max:255',
                'Sf_HalfDay' => 'nullable|string|max:255',
                'Sf_OtAllowed' => 'nullable|string|max:255',
                'Sf_OtGrace' => 'nullable|string|max:255',
                'Sf_OtRounding' => 'nullable|string|max:255',
                'Sf_MaxOTHrs' => 'nullable|string|max:255',
                'Sf_FlxIn_ST' => 'nullable|string|max:255',
                'Sf_FlxOut_ST' => 'nullable|string|max:255',
                'Sf_FlxIn_ET' => 'nullable|string|max:255',
                'Sf_FlxOut_ET' => 'nullable|string|max:255',
                'Sf_Rot_Days' => 'nullable|string|max:255',
                'Sf_WkOff' => 'nullable|string|max:255',
                'Sf_HolDy' => 'nullable|string|max:255',
                'Sf_NgtAllow' => 'nullable|string|max:255'
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => 'Validation errors',
                    'errors' => $validator->errors()
                ], 422);
            }

            $shift = ShiftMaster::create($request->all());

            return response()->json([
                'success' => true,
                'data' => $shift,
                'message' => 'Shift created successfully'
            ], 201);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Error creating shift',
                'error' => $e->getMessage()
            ], 500);
        }
    }

    public function show($id)
    {
        try {
            $shift = ShiftMaster::findOrFail($id);

            return response()->json([
                'success' => true,
                'data' => $shift,
                'message' => 'Shift retrieved successfully'
            ], 200);
        } catch (ModelNotFoundException $e) {
            return response()->json([
                'success' => false,
                'message' => 'Shift not found'
            ], 404);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Error retrieving shift',
                'error' => $e->getMessage()
            ], 500);
        }
    }

    public function update(Request $request, $id)
    {
        try {
            $validator = Validator::make($request->all(), [
                'Sf_Code' => 'nullable|string|max:255',
                'Sf_Name' => 'nullable|string|max:255',
                'Sf_Type' => 'nullable|string|max:255',
                'Sf_Stime' => 'nullable|string|max:255',
                'Sf_Etime' => 'nullable|string|max:255',
                'Sf_Hours' => 'nullable|string|max:255',
                'Sf_MidNight' => 'nullable|string|max:255',
                'Brk_Stime' => 'nullable|string|max:255',
                'Brk_Etime' => 'nullable|string|max:255',
                'Grc_In_Mnt' => 'nullable|string|max:255',
                'Grc_Out_Mnt' => 'nullable|string|max:255',
                'LtMrk_After' => 'nullable|string|max:255',
                'ErlMrk_Before' => 'nullable|string|max:255',
                'Sf_HalfDay' => 'nullable|string|max:255',
                'Sf_OtAllowed' => 'nullable|string|max:255',
                'Sf_OtGrace' => 'nullable|string|max:255',
                'Sf_OtRounding' => 'nullable|string|max:255',
                'Sf_MaxOTHrs' => 'nullable|string|max:255',
                'Sf_FlxIn_ST' => 'nullable|string|max:255',
                'Sf_FlxOut_ST' => 'nullable|string|max:255',
                'Sf_FlxIn_ET' => 'nullable|string|max:255',
                'Sf_FlxOut_ET' => 'nullable|string|max:255',
                'Sf_Rot_Days' => 'nullable|string|max:255',
                'Sf_WkOff' => 'nullable|string|max:255',
                'Sf_HolDy' => 'nullable|string|max:255',
                'Sf_NgtAllow' => 'nullable|string|max:255'
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => 'Validation errors',
                    'errors' => $validator->errors()
                ], 422);
            }

            $shift = ShiftMaster::findOrFail($id);
            $shift->update($request->all());

            return response()->json([
                'success' => true,
                'data' => $shift,
                'message' => 'Shift updated successfully'
            ], 200);
        } catch (ModelNotFoundException $e) {
            return response()->json([
                'success' => false,
                'message' => 'Shift not found'
            ], 404);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Error updating shift',
                'error' => $e->getMessage()
            ], 500);
        }
    }

    public function destroy($id)
    {
        try {
            $shift = ShiftMaster::findOrFail($id);
            $shift->delete();

            return response()->json([
                'success' => true,
                'message' => 'Shift deleted successfully'
            ], 200);
        } catch (ModelNotFoundException $e) {
            return response()->json([
                'success' => false,
                'message' => 'Shift not found'
            ], 404);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Error deleting shift',
                'error' => $e->getMessage()
            ], 500);
        }
    }
}
