<?php

namespace App\Http\Controllers;

use App\Models\SigniWorkMaster;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Database\Eloquent\ModelNotFoundException;

class SigniWorkMasterController extends Controller
{
    public function index(Request $request)
    {
        try {
            $perPage = $request->get('per_page', 15);
            $works = SigniWorkMaster::paginate($perPage);

            return response()->json([
                'success' => true,
                'data' => $works,
                'message' => 'Signi work records retrieved successfully'
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Error retrieving records',
                'error' => $e->getMessage()
            ], 500);
        }
    }

    public function all()
    {
        try {
            $works = SigniWorkMaster::all();

            return response()->json([
                'success' => true,
                'data' => $works,
                'message' => 'All signi work records retrieved successfully'
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Error retrieving records',
                'error' => $e->getMessage()
            ], 500);
        }
    }

    public function store(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'SWrk_Code' => 'nullable|string|max:30',
                'SWrk_Name' => 'required|string|max:200',
                'SWrk_Fees' => 'nullable|boolean',
                'Is_Reimburse' => 'nullable|boolean',
                'Is_Active' => 'nullable|boolean'
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => 'Validation errors',
                    'errors' => $validator->errors()
                ], 422);
            }

            $work = SigniWorkMaster::create($request->all());

            return response()->json([
                'success' => true,
                'data' => $work,
                'message' => 'Signi work record created successfully'
            ], 201);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Error creating record',
                'error' => $e->getMessage()
            ], 500);
        }
    }

    public function show($id)
    {
        try {
            $work = SigniWorkMaster::findOrFail($id);

            return response()->json([
                'success' => true,
                'data' => $work,
                'message' => 'Signi work record retrieved successfully'
            ], 200);
        } catch (ModelNotFoundException $e) {
            return response()->json([
                'success' => false,
                'message' => 'Record not found'
            ], 404);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Error retrieving record',
                'error' => $e->getMessage()
            ], 500);
        }
    }

    public function update(Request $request, $id)
    {
        try {
            $validator = Validator::make($request->all(), [
                'SWrk_Code' => 'nullable|string|max:30',
                'SWrk_Name' => 'required|string|max:200',
                'SWrk_Fees' => 'nullable|boolean',
                'Is_Reimburse' => 'nullable|boolean',
                'Is_Active' => 'nullable|boolean'
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'success' => false,
                    'message' => 'Validation errors',
                    'errors' => $validator->errors()
                ], 422);
            }

            $work = SigniWorkMaster::findOrFail($id);
            $work->update($request->all());

            return response()->json([
                'success' => true,
                'data' => $work,
                'message' => 'Signi work record updated successfully'
            ], 200);
        } catch (ModelNotFoundException $e) {
            return response()->json([
                'success' => false,
                'message' => 'Record not found'
            ], 404);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Error updating record',
                'error' => $e->getMessage()
            ], 500);
        }
    }

    public function destroy($id)
    {
        try {
            $work = SigniWorkMaster::findOrFail($id);
            $work->delete();

            return response()->json([
                'success' => true,
                'message' => 'Signi work record deleted successfully'
            ], 200);
        } catch (ModelNotFoundException $e) {
            return response()->json([
                'success' => false,
                'message' => 'Record not found'
            ], 404);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Error deleting record',
                'error' => $e->getMessage()
            ], 500);
        }
    }
}
