<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\SpecialDutyMaster;

class SpecialDutyMasterController extends Controller
{

    /**
     * List with Pagination + Search
     */
    public function index(Request $request)
    {
        try {

            $search = $request->get('search');

            $query = SpecialDutyMaster::query();

            if ($search) {
                $query->where(function ($q) use ($search) {
                    $q->where('SDt_Name', 'like', "%{$search}%")
                      ->orWhere('SDt_Code', 'like', "%{$search}%");
                });
            }

            $data = $query->orderBy('SDt_Id', 'desc')
                          ->paginate(15);

            return response()->json([
                'success' => true,
                'data' => $data,
                'message' => 'Special duty list fetched successfully.'
            ]);

        } catch (\Exception $e) {

            return response()->json([
                'success' => false,
                'message' => 'Failed to fetch data.',
                'error' => $e->getMessage()
            ], 500);
        }
    }


    /**
     * All Data without Pagination
     */
    public function all()
    {
        $data = SpecialDutyMaster::orderBy('SDt_Name')->get();

        return response()->json([
            'success' => true,
            'data' => $data
        ]);
    }


    /**
     * Store
     */
    public function store(Request $request)
    {
        $request->validate([
            'SDt_Name' => 'required|max:50'
        ]);

        $data = SpecialDutyMaster::create($request->all());

        return response()->json([
            'success' => true,
            'message' => 'Special duty created successfully.',
            'data' => $data
        ]);
    }


    /**
     * Show Single
     */
    public function show($id)
    {
        $data = SpecialDutyMaster::find($id);

        if (!$data) {
            return response()->json([
                'success' => false,
                'message' => 'Record not found.'
            ], 404);
        }

        return response()->json([
            'success' => true,
            'data' => $data
        ]);
    }


    /**
     * Update
     */
    public function update(Request $request, $id)
    {
        $data = SpecialDutyMaster::find($id);

        if (!$data) {
            return response()->json([
                'success' => false,
                'message' => 'Record not found.'
            ], 404);
        }

        $data->update($request->all());

        return response()->json([
            'success' => true,
            'message' => 'Special duty updated successfully.',
            'data' => $data
        ]);
    }


    /**
     * Delete
     */
    public function destroy($id)
    {
        $data = SpecialDutyMaster::find($id);

        if (!$data) {
            return response()->json([
                'success' => false,
                'message' => 'Record not found.'
            ], 404);
        }

        $data->delete();

        return response()->json([
            'success' => true,
            'message' => 'Special duty deleted successfully.'
        ]);
    }

}
