<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BranchMaster extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'branch_master';
    protected $primaryKey = 'Br_Id';

    protected $fillable = [
        'Br_Name',
        'Br_Code',
        'Br_GST_No',
        'Br_TDS_No',
        'Br_PAN_No',
        'Br_Address',
        'Br_City',
        'Br_State',
        'Br_Pin',
        'Br_Email',
        'Br_Mobile',
        'Br_URL',
        'Br_Logo',
    ];

    protected $casts = [
        'Br_Id' => 'integer',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'deleted_at' => 'datetime',
    ];

    // Accessor: Always return full URL for logo
    public function getBrLogoAttribute($value)
    {
        return $value ? asset('storage/' . $value) : null;
    }

    // Validation rules for CREATE
    public static function createRules()
    {
        return [
            'Br_Name'   => 'required|string|max:100',
            'Br_Code'   => 'nullable|string|max:25|unique:branch_master,Br_Code',
            'Br_GST_No' => 'nullable|string|max:50|unique:branch_master,Br_GST_No',
            'Br_TDS_No' => 'nullable|string|max:50',
            'Br_PAN_No' => 'nullable|string|max:50|unique:branch_master,Br_PAN_No',
            'Br_Address'=> 'nullable|string',
            'Br_City'   => 'nullable|string|max:50',
            'Br_State'  => 'nullable|string|max:50',
            'Br_Pin'    => 'nullable|string|max:10',
            'Br_Email'  => 'nullable|email|max:50',
            'Br_Mobile' => 'nullable|string|max:15',
            'Br_URL'    => 'nullable|url|max:150',
            'Br_Logo'   => 'nullable|image|mimes:jpg,jpeg,png,webp|max:2048'
        ];
    }

    // Validation rules for UPDATE
    public static function updateRules($id)
    {
        return [
            'Br_Name'   => 'sometimes|required|string|max:100',
            'Br_Code'   => 'sometimes|nullable|string|max:25|unique:branch_master,Br_Code,' . $id . ',Br_Id',
            'Br_GST_No' => 'nullable|string|max:50|unique:branch_master,Br_GST_No,' . $id . ',Br_Id',
            'Br_TDS_No' => 'nullable|string|max:50',
            'Br_PAN_No' => 'nullable|string|max:50|unique:branch_master,Br_PAN_No,' . $id . ',Br_Id',
            'Br_Address'=> 'nullable|string',
            'Br_City'   => 'nullable|string|max:50',
            'Br_State'  => 'nullable|string|max:50',
            'Br_Pin'    => 'nullable|string|max:10',
            'Br_Email'  => 'nullable|email|max:50',
            'Br_Mobile' => 'nullable|string|max:15',
            'Br_URL'    => 'nullable|url|max:150',
            'Br_Logo'   => 'nullable|string'
        ];
    }
}
