<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DebtTypeMaster extends Model
{
    use HasFactory;

    protected $table = 'debt_type_master';
    protected $primaryKey = 'DT_id';

    protected $fillable = [
        'DT_Code',
        'DT_Name',
        'DT_Cate',
        'DT_Lia_type',
        'Is_Active'
    ];

    protected $casts = [
        'Is_Active' => 'boolean',
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];

    const DT_CATE_LONG_TERM = 'Long Term';
    const DT_CATE_SHORT_TERM = 'Short Term';

    const DT_LIA_TYPE_PAYABLE = 'Payable';
    const DT_LIA_TYPE_DEPOSIT = 'Deposit';
    const DT_LIA_TYPE_LOAN = 'Loan';

    public static function getDtCateOptions()
    {
        return [
            self::DT_CATE_LONG_TERM => 'Long Term',
            self::DT_CATE_SHORT_TERM => 'Short Term',
        ];
    }

    public static function getDtLiaTypeOptions()
    {
        return [
            self::DT_LIA_TYPE_PAYABLE => 'Payable',
            self::DT_LIA_TYPE_DEPOSIT => 'Deposit',
            self::DT_LIA_TYPE_LOAN => 'Loan',
        ];
    }
}
