<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DeptMenuMap extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'dept_menu_map';
    protected $primaryKey = 'DMM_Id';

    // Mass assignable fields
    protected $fillable = [
        'Dpt_Id',
        'Fnc_Id',
        'Status',
    ];

    // Relationship: ek department ka mapping
    public function department()
    {
        return $this->belongsTo(Department::class, 'Dpt_Id', 'Dpt_id');
    }

        public function menus()
    {
        return $this->hasMany(FunctionType::class, 'Fnc_Id', 'Fnc_Id');
    }
}
