<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DeptWorkflow extends Model
{
    use HasFactory;

    protected $table = 'dept_workflow';
    protected $primaryKey = 'DWF_Id';
    public $timestamps = true;

    protected $fillable = [
        'Dpt_Id',
        'Wef_Date',
        'Dsg_Id',
        'Emp_Id',
        'Trn_SrNo',
        'Trn_Stage',
        'Trn_Method',
        'Trn_Tet',
    ];

    protected $casts = [
        'Dpt_Id' => 'integer',
        'Dsg_Id' => 'integer',
        'Emp_Id' => 'integer',
        'Wef_Date' => 'date',
    ];

    protected $dates = [
        'Wef_Date',
        'created_at',
        'updated_at'
    ];

    // Relations
    public function department()
    {
        return $this->belongsTo(department::class, 'Dpt_Id', 'Dpt_id');
    }

    public function designation()
    {
        return $this->belongsTo(DesignationMaster::class, 'Dsg_Id', 'Dsg_id');
    }

    public function employee()
    {
        return $this->belongsTo(EmployeeMaster::class, 'Emp_Id', 'Emp_Id');
    }
}
