<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DesignationMaster extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'designation_master';
    protected $primaryKey = 'Dsg_id';

    protected $fillable = [
        'Dsg_Title',
        'Dsg_Desc',
        'Dsg_EName',
        'UpGrp',
        'GrCod',
        'GrSrn',
        'GrStt',
        'isvisible',
    ];

    protected $casts = [
        'Dsg_Title' => 'string',
        'Dsg_Desc'  => 'string',
        'Dsg_EName' => 'string',
        'UpGrp'     => 'string',
        'GrCod'     => 'string',
        'GrSrn'     => 'string',
        'GrStt'     => 'string',
        'isvisible' => 'integer',
    ];

    public function scopeActive($query)
    {
        return $query->where('isvisible', 1);
    }

    public function scopeInactive($query)
    {
        return $query->where('isvisible', 0);
    }

    public function getIsVisibleAttribute()
    {
        return $this->attributes['isvisible'] == 1 ? 'Active' : 'Inactive';
    }
}
