<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EmpPersProfile extends Model
{
    use SoftDeletes;

    protected $table = 'emppers_profile';
    protected $primaryKey = 'EPP_Id';

    protected $fillable = [
        'Emp_Id',
        'EPP_Date',
        'EGM_Id',
        'Dpt_id',
        'Dsg_Id',
        'PS_Id',
        'ETy_Id',
        'Join_Date',
        'Est_Id',
        'Is_Active'
    ];

    protected $casts = [
        'Is_Active' => 'boolean',
        'EPP_Date' => 'date',
        'Join_Date' => 'date'
    ];

    

   public function employee()
{
    return $this->belongsTo(EmployeeMaster::class, 'Emp_Id', 'Emp_Id'); // 
}

    public function grade()
    {
        return $this->belongsTo(EmployeeGradeMaster::class, 'EGM_Id', 'EGM_Id');
    }

    public function department()
    {
        return $this->belongsTo(Department::class, 'Dpt_id', 'Dpt_id');
    }

    public function designation()
    {
        return $this->belongsTo(DesignationMaster::class, 'Dsg_Id', 'Dsg_id');
    }

    public function payScale()
    {
        return $this->belongsTo(PayScaleMaster::class, 'PS_Id', 'PS_Id');
    }

    public function empType()
    {
        return $this->belongsTo(EmpTypeMaster::class, 'ETy_Id', 'ETy_Id');
    }

    public function empStatus()
    {
        return $this->belongsTo(EmployeeStatusMaster::class, 'Est_Id', 'Est_Id');
    }
}