<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EmpQuotaMaster extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'emp_quota_master';
    protected $primaryKey = 'Qut_Id';

    protected $fillable = [
        'Qut_Code',
        'Qut_Name',
        'Percentage',
        'Is_Active'
    ];

    protected $casts = [
        'Percentage' => 'decimal:2',
        'Is_Active' => 'boolean'
    ];
}
