<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EmpeduProfile extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'empedu_profile';
    protected $primaryKey = 'EEP_Id';
    public $timestamps = true;

    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';
    const DELETED_AT = 'deleted_at';

    protected $fillable = [
        'Emp_Id',
        'EEP_Date',
        'EED_Id',
        'Obtain_Grade',
        'Obtain_Marks',
        'Total_Marks',
        'Pass_Year',
        'Name_Insti',
        'Is_Active'
    ];

    protected $casts = [
        'Is_Active' => 'boolean',
        'EED_Id' => 'integer',
        'Obtain_Grade' => 'integer',
        'Obtain_Marks' => 'integer',
        'Total_Marks' => 'integer',
        'EEP_Date' => 'date'
    ];

    /**
     * Get the employee master that owns the education profile.
     */
    public function employeeMaster()
    {
        return $this->belongsTo(EmployeeMaster::class, 'Emp_Id', 'Emp_Id');
    }

    /**
     * Short alias for the employee relationship
     */
    public function employee()
    {
        return $this->belongsTo(EmployeeMaster::class, 'Emp_Id', 'Emp_Id');
    }

    /**
     * Get the education degree master associated with this profile.
     */
    public function educationDegree()
    {
        return $this->belongsTo(EmpEduMaster::class, 'EED_Id', 'EEd_Id');
    }
    
    /**
     * Alternative name for debugging
     */
    public function degree()
    {
        return $this->belongsTo(EmpEduMaster::class, 'EED_Id', 'EEd_Id');
    }
}