<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EmployeeGradeMaster extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'emp_grade_master';

    protected $primaryKey = 'EGM_Id';

    protected $fillable = [
        'EGM_Code',
        'EGM_Name',
        'PB_ID',
        'Is_Active'
    ];
    public function payBand()
    {
        return $this->belongsTo(PayBandMaster::class, 'PB_ID', 'PB_Id');
    }
}
