<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EmployeeMaster extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'employee_master';
    protected $primaryKey = 'Emp_Id';
    
    
    public $incrementing = true;
    protected $keyType = 'int';

    protected $fillable = [
        'Emp_Code',
        'First_Name',
        'Last_Name',
        'Dpt_Id',
        'Caste_Id',
        'Qut_Id',
        'Ect_Id',
        'Usr_Id',
        'ELg_Id',
        'Phone',
        'Email_Id',
        'Alt_Phone',
        'F_M',
        'Emp_Add1',
        'Emp_Add2',
        'Emp_Add3',
        'Birth_Date',
        'Bank_AcNo',
        'Bank_Name',
        'Bank_Br_Name',
        'BkAc_Type',
        'Gpf_AcNo_Pref',
        'Gpf_AcNo',
        'Cpf_AcNo',
        'Inc_TxNo',
        'UID_AdharNo',
        'Is_Active'
    ];

    protected $casts = [
        'ELg_Id' => 'array',
        'Is_Active' => 'boolean',
        'Birth_Date' => 'date'
    ];

    /*
    ===============================
    FK RELATIONS
    ===============================
    */

    public function department()
    {
        return $this->belongsTo(Department::class, 'Dpt_Id', 'Dpt_id');
    }

    public function caste()
    {
        return $this->belongsTo(CasteMaster::class, 'Caste_Id', 'Caste_Id');
    }

    public function quota()
    {
        return $this->belongsTo(EmpQuotaMaster::class, 'Qut_Id', 'Qut_Id');
    }

    public function category()
    {
        return $this->belongsTo(EmpCatMaster::class, 'Ect_Id', 'ECt_Id');
    }

    public function user()
    {
        return $this->belongsTo(UserMaster::class, 'Usr_Id', 'Usr_Id');
    }

    /*
    ===============================
    Languages (JSON IDs)
    ===============================
    */

    public function languagesData()
    {
        return EmpLangMaster::whereIn('ELg_Id', $this->ELg_Id ?? [])->get();
    }
    

}