<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FamilyInfoMaster extends Model
{
    use SoftDeletes;

    protected $table = 'family_info_master';
    protected $primaryKey = 'EFI_Id';

    protected $fillable = [
        'Emp_id',
        'Member_name',
        'Gender',
        'Rela_Id',
        'Dob',
        'Phone',
        'Is_Active'
    ];

    protected $casts = [
        'Emp_id' => 'integer',
        'Rela_Id' => 'integer',
        'Is_Active' => 'integer'
    ];

    public function employee()
    {
        return $this->belongsTo(EmployeeMaster::class, 'Emp_id', 'Emp_Id');
    }

    public function relationship()
    {
        return $this->belongsTo(RelationshipMaster::class, 'Rela_Id', 'Rela_Id');
    }
}