<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FunctionType extends Model
{
    use HasFactory, SoftDeletes;

    protected $primaryKey = 'Fnc_Id';

    protected $fillable = [
        'Fnc_Title',
        'Fnc_Desc',
        'GrCod',
        'UpGrp',
        'GrSrn',
        'GrStt',
        'isvisible',
        'Description',
        'Menu_Links',
    ];

    protected $casts = [
        'Fnc_Title'    => 'string',
        'Fnc_Desc'     => 'string',
        'GrCod'        => 'string',
        'UpGrp'        => 'string',
        'GrSrn'        => 'string',
        'GrStt'        => 'string',
        'isvisible'    => 'integer',
        'Description'  => 'string',
        'Menu_Links'   => 'string',
    ];

    // Scope for active records
    public function scopeActive($query)
    {
        return $query->where('isvisible', 1);
    }

    // Scope for inactive records
    public function scopeInactive($query)
    {
        return $query->where('isvisible', 0);
    }

    // Accessor for isvisible status
    public function getIsVisibleAttribute()
    {
        return $this->attributes['isvisible'] == 1 ? 'Active' : 'Inactive';
    }
}
