<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FundsTypeMaster extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'funds_type_master';
    protected $primaryKey = 'FT_id';

    protected $fillable = [
        'FT_Code',
        'FT_Name',
        'FT_Type',
        'FT_Source',
        'GT_Id',
        'FT_Category',
        'Is_Active',
    ];

    protected $casts = [
        'Is_Active' => 'boolean',
        'GT_Id'     => 'integer',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'deleted_at' => 'datetime',
    ];

    /**
     * Relationship with GrantTypeMaster (assuming table grant_type_master & PK GT_id)
     */
    public function grantType()
    {
        return $this->belongsTo(GrantTypeMaster::class, 'GT_Id', 'GT_Id');
    }
}
