<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FyearMaster extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'fyear_master';
    protected $primaryKey = 'FY_id';          // ya FY_Id jo bhi migration mein rakha

    protected $fillable = [
        'FY_Code',
        'FY_Name',
        'St_Date',
        'Ed_Date',
        'is_current_year',
        'is_budget_open',
        'is_transaction_open',
        'is_month_end_closed',
        'is_year_end_closed',
        'PY_Id',
        'NY_Id',
        'Remarks',
        'Status',
    ];

    protected $casts = [
        'St_Date'              => 'date:Y-m-d',
        'Ed_Date'              => 'date:Y-m-d',
        'is_current_year'      => 'boolean',
        'is_budget_open'       => 'boolean',
        'is_transaction_open'  => 'boolean',
        'is_month_end_closed'  => 'boolean',
        'is_year_end_closed'   => 'boolean',
        'PY_Id'                => 'integer',
        'NY_Id'                => 'integer',
    ];

    // Relationships
    public function previousYear()
    {
        return $this->belongsTo(FyearMaster::class, 'PY_Id', 'FY_id');
    }

    public function nextYear()
    {
        return $this->belongsTo(FyearMaster::class, 'NY_Id', 'FY_id');
    }

    // Scopes
    public function scopeActive($query)
    {
        return $query->where('Status', 'ACTIVE');
    }

    public function scopeCurrent($query)
    {
        return $query->where('is_current_year', true);
    }

    // Helper methods
    public function isCurrent(): bool
    {
        return (bool) $this->is_current_year;
    }

    public function isBudgetOpen(): bool
    {
        return (bool) $this->is_budget_open;
    }
}
