<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class GrantAuthoMaster extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'grant_autho_master';
    protected $primaryKey = 'GA_Id';

    protected $fillable = [
        'GA_Code',
        'GA_Name',
        'is_active'
    ];

    protected $casts = [
        'GA_Id' => 'integer',
        'is_active' => 'boolean'
    ];

    /* ================= VALIDATION RULES ================= */

    public static function createRules()
    {
        return [
            'GA_Code' => 'nullable|string|max:50|unique:grant_autho_master,GA_Code',
            'GA_Name' => 'required|string|max:50'
        ];
    }

    public static function updateRules($id)
    {
        return [
            'GA_Code' => 'sometimes|nullable|string|max:50|unique:grant_autho_master,GA_Code,' . $id . ',GA_Id',
            'GA_Name' => 'sometimes|required|string|max:50',
            'is_active' => 'sometimes|boolean'
        ];
    }

    /* ================= SCOPES ================= */

    public function scopeActive($query)
    {
        return $query->where('is_active', 1);
    }

    /* ================= BUSINESS METHODS ================= */

    public function deactivate()
    {
        $this->update(['is_active' => 0]);
        return $this;
    }

    public function activate()
    {
        $this->update(['is_active' => 1]);
        return $this;
    }
}
