<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GrantTypeMaster extends Model
{
    use HasFactory;

    protected $table = 'grant_type_master';
    protected $primaryKey = 'GT_Id';

    protected $fillable = [
        'GT_Code',
        'GT_Name',
        'GT_Nature',
        'GT_Condition',
        'GT_Utl_From_Date',
        'GT_Utl_To_Date',
        'GT_Act_Mode',
        'GT_Status',
        'GT_Au_Id',
        'Is_Active'
    ];

    protected $casts = [
        'Is_Active' => 'boolean',
        'GT_Utl_From_Date' => 'date',
        'GT_Utl_To_Date' => 'date',
        'GT_Au_Id' => 'integer'
    ];

    // Relationship with GrantAuthoMaster
    public function grantAuthority()
    {
        return $this->belongsTo(GrantAuthoMaster::class, 'GT_Au_Id', 'GA_Id');
    }

    // Relationship with GrantDivisionMapping
    // public function departmentMappings()
    // {
    //     return $this->hasMany(GrantDivisionMapping::class, 'grant_ty_id', 'GT_Id');
    // }
}
