<?php
// app/Models/HolidayDeptMap.php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class HolidayDeptMap extends Model
{
    use SoftDeletes;

    protected $table = 'holiday_dept_map';
    protected $primaryKey = 'HLDp_Id';

    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';
    const DELETED_AT = 'deleted_at';

    protected $fillable = [
        'HL_Id',
        'Dpt_id',
        'HD_Status'
    ];

    protected $casts = [
        'HL_Id' => 'integer',
        'Dpt_id' => 'integer',
        'HD_Status' => 'boolean',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'deleted_at' => 'datetime'
    ];

    public function holiday()
    {
        return $this->belongsTo(HolidayMaster::class, 'HL_Id', 'HL_Id');
    }

    public function department()
    {
        return $this->belongsTo(Department::class, 'Dpt_id', 'Dpt_id');
    }
}
