<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class HolidayDsgMap extends Model
{
    use SoftDeletes;

    protected $table = 'holiday_dsg_map';
    protected $primaryKey = 'HLDS_Id';

    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';
    const DELETED_AT = 'deleted_at';

    protected $fillable = [
        'HL_Id',
        'Dsg_Id',
        'HDS_Status'
    ];

    protected $casts = [
        'HL_Id' => 'integer',
        'Dsg_Id' => 'integer',
        'HDS_Status' => 'boolean',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'deleted_at' => 'datetime'
    ];

    public function holidayMaster()
    {
        return $this->belongsTo(HolidayMaster::class, 'HL_Id', 'HL_Id');
    }

    public function designationMaster()
    {
        return $this->belongsTo(DesignationMaster::class, 'Dsg_Id', 'Dsg_id');
       
    }
}