<?php
// app/Models/HolidayEmpTyMap.php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class HolidayEmpTyMap extends Model
{
    use SoftDeletes;

    protected $table = 'holiday_empty_map';  
    protected $primaryKey = 'HLET_Id';

    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';
    const DELETED_AT = 'deleted_at';

    protected $fillable = [
        'HL_Id',
        'ETy_Id',
        'HET_Status'
    ];

    protected $casts = [
        'HL_Id' => 'integer',
        'ETy_Id' => 'integer',
        'HET_Status' => 'boolean',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'deleted_at' => 'datetime'
    ];

    public function holidayMaster()
    {
        return $this->belongsTo(HolidayMaster::class, 'HL_Id', 'HL_Id');
    }

    public function empTypeMaster()
    {
        return $this->belongsTo(EmpTypeMaster::class, 'ETy_Id', 'ETy_Id');
    }
}