<?php
// app/Models/HolidayMaster.php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class HolidayMaster extends Model
{
    use SoftDeletes;

    protected $table = 'holiday_master';
    protected $primaryKey = 'HL_Id';

    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';
    const DELETED_AT = 'deleted_at';

    protected $fillable = [
        'HL_Code',
        'HL_Name',
        'CI_Year',
        'HL_Date',
        'HL_Type',
        'HL_Cate',
        'HL_ISPaid',
        'HL_ISOptional',
        'HL_ISCmpnst',
        'HL_AttnImpact',
        'HL_PayImpact',
        'HL_OTAllowed',
        'HL_Status',
        'Remarks'
    ];

    protected $casts = [
        'HL_Status' => 'boolean',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'deleted_at' => 'datetime'
    ];
}
