<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class HolidayShiftMap extends Model
{
    use SoftDeletes;

    protected $table = 'holiday_shift_map';
    protected $primaryKey = 'HLSF_Id';

    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';
    const DELETED_AT = 'deleted_at';

    protected $fillable = [
        'HL_Id',
        'Sf_Id',
        'HDS_Status'
    ];

    protected $casts = [
        'HL_Id' => 'integer',
        'Sf_Id' => 'integer',
        'HDS_Status' => 'boolean',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'deleted_at' => 'datetime'
    ];

    public function holidayMaster()
    {
        return $this->belongsTo(HolidayMaster::class, 'HL_Id', 'HL_Id');
    }

    public function shiftMaster()
    {
        return $this->belongsTo(ShiftMaster::class, 'Sf_Id', 'Sf_Id');
    }
}
