<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class IncExamMaster extends Model
{
    use SoftDeletes;

    protected $table = 'inc_exam_master';
    protected $primaryKey = 'EEd_Id';

    protected $fillable = [
        'EEd_Code',
        'EEd_Name',
        'Is_Active',
        'Is_Mandatory',
        'Is_Technical',
        'Is_Professional',
        'Is_Promotional',
        'Rec_Valid'
    ];

    protected $casts = [
        'Is_Active' => 'boolean',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'deleted_at' => 'datetime'
    ];
}
