<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class InvoiceChargeMaster extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'invoice_charge_master';
    protected $primaryKey = 'IC_Id';

    protected $fillable = [
        'IC_Code',
        'IC_Name',
        'Percentage',
        'Lg_Id',
    ];


    public function ledger()
    {
        return $this->belongsTo(LedgerMaster::class, 'Lg_Id', 'Lg_Id');
    }

}
