<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LeaveTypeMaster extends Model
{
    use SoftDeletes;

    protected $table = 'leave_type_master';
    protected $primaryKey = 'LT_id';

    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';
    const DELETED_AT = 'deleted_at';

    protected $fillable = [
        'LT_code',
        'LT_name',
        'Max_days',
        'Is_Paid',
        'Is_Active'
    ];

    protected $casts = [
        'LT_id' => 'integer',
        'Max_days' => 'integer',
        'Is_Paid' => 'boolean',
        'Is_Active' => 'boolean',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'deleted_at' => 'datetime'
    ];
}
