<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PayAlwdedMaster extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'pay_alwded_master';
    protected $primaryKey = 'PAD_Id';

    protected $fillable = [
        'PAD_Code',
        'PAD_ShortName',
        'PAD_Name',
        'Percentage',
        'Alw_Ded',
        'Lg_Id'
    ];

    public function ledger()
    {
        return $this->belongsTo(LedgerMaster::class, 'Lg_Id', 'Lg_Id');
    }
}
