<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PayBandMaster extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'pay_band_master';

    protected $primaryKey = 'PB_Id';

    protected $fillable = [
        'PC_Id',
        'PB_Code',
        'Min_Pay',
        'Max_Pay'
    ];

    protected $casts = [
        'Min_Pay' => 'decimal:2',
        'Max_Pay' => 'decimal:2'
    ];

    public function commission()
    {
        return $this->belongsTo(PayCommissionMaster::class, 'PC_Id', 'PC_Id');
    }
}
