<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PayCommissionMaster extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'pay_comm_master';

    protected $primaryKey = 'PC_Id';

    protected $fillable = [
        'PC_Name',
        'PST_Id',
        'Eff_From',
        'Eff_To',
        'PST_Desc',
        'Is_Active'
    ];

    protected $casts = [
        'Eff_From' => 'date',
        'Eff_To'   => 'date',
        'Is_Active' => 'boolean'
    ];

    // ✅ relation same logic only field changed
    public function structureType()
    {
        return $this->belongsTo(
            PayStrtypeMaster::class,
            'PST_Id',
            'PST_Id'
        );
    }

    // public function payScales()
    // {
    //     return $this->hasMany(PayScaleMaster::class, 'PC_Id');
    // }

    // public function payBands()
    // {
    //     return $this->hasMany(PayBandMaster::class, 'PC_Id');
    // }

    // public function gradePays()
    // {
    //     return $this->hasMany(GradePayMaster::class, 'PC_Id');
    // }

    // public function payMatrixLevels()
    // {
    //     return $this->hasMany(PayMatrixLevelMaster::class, 'PC_Id');
    // }
}
