<?php
// app/Models/PayScaleMaster.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PayScaleMaster extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'pay_scale_master';

    protected $primaryKey = 'PS_Id';

    protected $fillable = [
        'PC_Id',
        'Scl_Code',
        'St_Basic',
        'Inc_Amount',
        'Inc_Steps',
        'Max_Basic'
    ];

    protected $casts = [
        'St_Basic'   => 'decimal:2',
        'Inc_Amount' => 'decimal:2',
        'Max_Basic'  => 'decimal:2'
    ];

    public function commission()
    {
        return $this->belongsTo(PayCommissionMaster::class, 'PC_Id', 'PC_Id');
    }
}
