<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class RelationshipMaster extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'relationship_master';

    // REAL DB PRIMARY KEY
    protected $primaryKey = 'Rela_Id';

    public $incrementing = true;
    protected $keyType = 'int';
    public $timestamps = true;

    /*
    |--------------------------------------------------------------------------
    | Attribute Mapping (VERY IMPORTANT)
    |--------------------------------------------------------------------------
    | This allows controller to use:
    | relation_id, relation_code, relation_name
    | while DB columns are:
    | Rela_Id, Rela_Code, Rela_Name
    */

    protected $fillable = [
        'Rela_Code',
        'Rela_Name'
    ];


    // 🔥 Accessors (Alias fields)
    public function getRelationIdAttribute()
    {
        return $this->Rela_Id;
    }

    public function getRelationCodeAttribute()
    {
        return $this->Rela_Code;
    }

    public function getRelationNameAttribute()
    {
        return $this->Rela_Name;
    }

    // 🔥 Mutators (Allow insert/update from controller)
    public function setRelationCodeAttribute($value)
    {
        $this->attributes['Rela_Code'] = $value;
    }

    public function setRelationNameAttribute($value)
    {
        $this->attributes['Rela_Name'] = $value;
    }

    // public function familyMembers()
    // {
    //     return $this->hasMany(FamilyInfoMaster::class, 'Rela_Id', 'Rela_Id');
    // }
}
