<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SchemeMaster extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'scheme_master';
    protected $primaryKey = 'Sch_id';

    protected $fillable = [
        'Sch_Code',
        'Sch_Name',
        'Dept_Id',
        'GT_Id',
        'St_Date',
        'Ed_Date',
        'Budget',
        'Status',
        'Is_Active'
    ];

    protected $casts = [
        'Budget' => 'decimal:2',
        'Is_Active' => 'boolean',
        'St_Date' => 'date',
        'Ed_Date' => 'date'
    ];

    /*
    |--------------------------------------------------------------------------
    | Relationships
    |--------------------------------------------------------------------------
    */

    public function department()
    {
        return $this->belongsTo(Department::class, 'Dept_Id', 'Dpt_id');
    }

    public function grantType()
    {
        return $this->belongsTo(
            GrantTypeMaster::class,
            'GT_Id',
            'GT_Id'
        );
    }
}
