<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ShiftMaster extends Model
{
    use SoftDeletes;

    protected $table = 'shift_master';
    protected $primaryKey = 'Sf_Id';

    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';
    const DELETED_AT = 'deleted_at';

    protected $fillable = [
        'Sf_Code',
        'Sf_Name',
        'Sf_Type',
        'Sf_Stime',
        'Sf_Etime',
        'Sf_Hours',
        'Sf_MidNight',
        'Brk_Stime',
        'Brk_Etime',
        'Grc_In_Mnt',
        'Grc_Out_Mnt',
        'LtMrk_After',
        'ErlMrk_Before',
        'Sf_HalfDay',
        'Sf_OtAllowed',
        'Sf_OtGrace',
        'Sf_OtRounding',
        'Sf_MaxOTHrs',
        'Sf_FlxIn_ST',
        'Sf_FlxOut_ST',
        'Sf_FlxIn_ET',
        'Sf_FlxOut_ET',
        'Sf_Rot_Days',
        'Sf_WkOff',
        'Sf_HolDy',
        'Sf_NgtAllow'
    ];

    protected $casts = [
        'Sf_Id' => 'integer',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'deleted_at' => 'datetime'
    ];
}
