<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SigniWorkMaster extends Model
{
    use SoftDeletes;

    protected $table = 'signi_work_master';  // Changed to small letters
    protected $primaryKey = 'SWrk_Id';

    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';
    const DELETED_AT = 'deleted_at';

    protected $fillable = [
        'SWrk_Code',
        'SWrk_Name',
        'SWrk_Fees',
        'Is_Reimburse',
        'Is_Active'
    ];

    protected $casts = [
        'SWrk_Id' => 'integer',
        'SWrk_Fees' => 'boolean',
        'Is_Reimburse' => 'boolean',
        'Is_Active' => 'boolean',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'deleted_at' => 'datetime'
    ];
}
