<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class UsrDptMap extends Model
{
    protected $table = 'usr_dept_map';
    protected $primaryKey = 'UDM_Id';
    public $incrementing = true;
    protected $keyType = 'int';

    protected $fillable = [
        'Usr_Id',
        'Dpt_Id',
        'Status'
    ];

    public function user()
    {
        return $this->belongsTo(UserMaster::class, 'Usr_Id', 'Usr_Id');
        // ^^^ check this too — make sure UserMaster has primaryKey = 'Usr_Id'
    }

    public function department()
    {
        // Fix: use exact column name from dept_master table
        return $this->belongsTo(Department::class, 'Dpt_Id', 'Dpt_id');
        //                                 foreignKey     ownerKey (primary key of Department)
    }
}
