<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class VendInvParameter extends Model
{
    use SoftDeletes;

    protected $table = 'vendinv_parameter';
    protected $primaryKey = 'VIP_Id';

    protected $fillable = [
        'TnT_ID',
        'Eff_Date',
        'VIP_Sr',
        'IC_Id',
        'Add_Dedu',
        'Lg_Id',
        'Percent',
        'Formula'
    ];

    protected $casts = [
        'Eff_Date' => 'date',
        'Percent' => 'float'
    ];

    const DEDUCT = 0;
    const ADD = 1;

    const ADD_DEDUCT_TEXTS = [
        self::DEDUCT => 'Deduct',
        self::ADD => 'Add'
    ];

    protected $appends = [
        'add_deduct_text',
        'is_active'
    ];

    public function getAddDeductTextAttribute()
    {
        return self::ADD_DEDUCT_TEXTS[$this->Add_Dedu] ?? 'Unknown';
    }

    public function getIsActiveAttribute(): bool
    {
        return is_null($this->deleted_at);
    }

    /*
    |--------------------------------------------------------------------------
    | Relationships
    |--------------------------------------------------------------------------
    */

    public function TendorType()
    {
        return $this->belongsTo(TenderType::class, 'TnT_ID', 'TnT_ID');
    }

    public function ledger()
    {
        return $this->belongsTo(LedgerMaster::class, 'Lg_Id', 'Lg_Id');
    }

    public function InvoiceCharge()
    {
        return $this->belongsTo(InvoiceChargeMaster::class, 'IC_Id', 'IC_Id');
    }
}
