<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('dept_master', function (Blueprint $table) {
            $table->id('Dpt_id'); // bigint unsigned AUTO_INCREMENT primary key
            $table->string('Dpt_Desc')->nullable();
            $table->string('Dpt_Name')->nullable();
            $table->string('GrCod')->nullable();
            $table->string('UpGrp')->nullable();
            $table->string('GrSrn')->nullable();
            $table->string('GrStt')->nullable();
            $table->tinyInteger('isvisible')->default(1)->comment('0=Inactive, 1=Active');
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable(); // for soft deletes
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('dept_master');
    }
};
