<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('usr_dept_map', function (Blueprint $table) {
            $table->bigIncrements('UDM_Id'); // Primary key
            $table->unsignedBigInteger('Dpt_Id')->nullable()->index(); // Department ID
            $table->unsignedBigInteger('Usr_Id')->nullable()->index(); // User ID
            $table->tinyInteger('Status')->default(1); // Status
            $table->timestamps(); // created_at + updated_at
            $table->softDeletes(); // deleted_at

          
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('usr_dept_map');
    }
};
