<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('function_types', function (Blueprint $table) {
            $table->bigIncrements('Fnc_Id'); // Primary Key
            $table->string('Fnc_Title')->nullable()->index();
            $table->string('Fnc_Desc')->nullable();
            $table->string('GrCod')->nullable()->index();
            $table->string('UpGrp')->nullable()->index();
            $table->string('GrSrn')->nullable();
            $table->string('GrStt')->nullable()->index();
            $table->tinyInteger('isvisible')->default(1)->comment('0=Inactive, 1=Active');
            $table->string('Description')->nullable();
            $table->string('Menu_Links')->nullable();
            $table->timestamps(); // created_at & updated_at
            $table->softDeletes(); // deleted_at
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('function_types');
    }
};
