<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('dept_menu_map', function (Blueprint $table) {
            $table->bigIncrements('DMM_Id');
            $table->unsignedBigInteger('Dpt_Id');

            $table->longText('Fnc_Id'); // longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL

            $table->tinyInteger('Status')->default(1);

            // Timestamps (Laravel default)
            $table->timestamps();

            // Soft deletes support
            $table->softDeletes();

            // Foreign key relationship
            $table->foreign('Dpt_Id')
                  ->references('Dpt_id')  // dept_master table ka primary key
                  ->on('dept_master')     // parent table
                  ->onUpdate('cascade')   // update hone par cascade
                  ->onDelete('cascade');  // delete hone par cascade
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('dept_menu_map', function (Blueprint $table) {
            // Drop foreign key first
            $table->dropForeign(['Dpt_Id']);
        });

        Schema::dropIfExists('dept_menu_map');
    }
};
