<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('org_master', function (Blueprint $table) {
            // Primary key
            $table->bigIncrements('Org_Id');                    // bigint(20) UNSIGNED AUTO_INCREMENT

            // Main fields
            $table->string('Org_Name', 255);                    // varchar(255) NOT NULL
            $table->string('Org_Code', 25)->nullable();         // varchar(25) NULL
            $table->string('Org_GST_No', 50)->nullable();       // varchar(50) NULL
            $table->string('Org_TDS_No', 50)->nullable();       // varchar(50) NULL
            $table->string('Org_PAN_No', 50)->nullable();       // varchar(50) NULL
            $table->text('Org_Address')->nullable();            // text NULL

            $table->string('Org_City', 100)->nullable()->index();   // varchar(100) NULL + INDEX
            $table->string('Org_State', 100)->nullable();           // varchar(100) NULL
            $table->string('Org_Pin', 10)->nullable();              // varchar(10) NULL

            $table->string('Org_Email', 100)->nullable()->index();  // varchar(100) NULL + INDEX (assuming you want index on email too)
            $table->string('Org_Mobile', 20)->nullable()->index();  // varchar(20) NULL + INDEX

            $table->string('Org_URL', 255)->nullable();             // varchar(255) NULL
            $table->string('Org_Logo', 255)->nullable();            // varchar(255) NULL (usually stores path/filename)

            // Timestamps (soft delete style)
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable();            // for soft deletes
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('org_master');
    }
};
