<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('fyear_master', function (Blueprint $table) {

            $table->bigIncrements('FY_Id');                     // bigint unsigned auto_increment primary key

            $table->string('FY_Code', 9)->nullable(false);      // varchar(9) NOT NULL
            $table->string('FY_Name', 20)->nullable();          // varchar(20) NULL

            $table->date('St_Date');                            // date NOT NULL
            $table->date('Ed_Date');                            // date NOT NULL

            $table->tinyInteger('is_current_year')->unsigned()->default(0);
            $table->tinyInteger('is_budget_open')->unsigned()->default(0);
            $table->tinyInteger('is_transaction_open')->unsigned()->default(0);
            $table->tinyInteger('is_month_end_closed')->unsigned()->default(0);
            $table->tinyInteger('is_year_end_closed')->unsigned()->default(0);

            $table->unsignedBigInteger('PY_Id')->nullable();
            $table->unsignedBigInteger('NY_Id')->nullable();

            $table->string('Remarks', 255)->nullable();

            $table->enum('Status', ['ACTIVE', 'CLOSED', 'LOCKED'])
                  ->default('ACTIVE');

            $table->timestamps();           // created_at + updated_at
            $table->softDeletes();          // deleted_at (soft delete)

            // Optional useful indexes
            $table->index('FY_Code');
            $table->index('Status');
            $table->index(['St_Date', 'Ed_Date']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('fyear_master');
    }
};
